% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_make_model.R
\name{aml_make_model}
\alias{aml_make_model}
\title{Function to train Deep Learning regression model for a single currency pair}
\usage{
aml_make_model(symbol, num_bars, timeframe, path_model, path_data)
}
\arguments{
\item{symbol}{Character symbol of the asset for which to train the model}

\item{num_bars}{Number of bars used to detect pattern}

\item{timeframe}{Data timeframe e.g. 1 min}

\item{path_model}{Path where the models are be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}
}
\value{
Function is writing file object with the model
}
\description{
Function is training h2o deep learning model to match future prices of the asset to the indicator pattern.
Main idea is to be able to predict future prices by solely relying on the most recent indicator pattern.
This is to mimic traditional algorithmic systems based on the indicator rule attempting to automate optimization process with AI.

Deep learning model structure is obtained from the 6 random combinations of neurons within 4 layers of the network,
the most accurate model configuration will be automatically selected

In addition the function will check if there is a need to update the model. To do that function will check
results of the function aml_test_model.R.
}
\details{
Function is using the dataset prepared by the function aml_collect_data.R.
Function will start to train the model as soon as there are more than 100 rows in the dataset
}
\examples{

\donttest{


library(dplyr)
library(readr)
library(h2o)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

data(EURUSDM15X75)
write_rds(EURUSDM15X75, file.path(path_data, 'EURUSDM15X75.rds'))

# start h2o engine (using all CPU's by default)
h2o.init()


# performing Deep Learning Regression using the custom function
aml_make_model(symbol = 'EURUSD',
               num_bars = 75,
               timeframe = 15,
               path_model = path_model,
               path_data = path_data)

# stop h2o engine
h2o.shutdown(prompt = F)

}



}
\author{
(C) 2019 Vladimir Zhbanko
}
