% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_distance.R
\name{lawn_line_distance}
\alias{lawn_line_distance}
\title{Measure a linestring}
\usage{
lawn_line_distance(line, units, lint = FALSE)
}
\arguments{
\item{line}{Line to measure, a \link{data-Feature}<(\link{data-LineString})>,
or \link{data-FeatureCollection}<(\link{data-LineString})>}

\item{units}{Can be degrees, radians, miles, or kilometers.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
Length of the input line (numeric).
}
\description{
Takes a \link{data-LineString} and measures its length in
the specified units.
}
\examples{
line <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "LineString",
    "coordinates": [
      [-77.031669, 38.878605],
      [-77.029609, 38.881946],
      [-77.020339, 38.884084],
      [-77.025661, 38.885821],
      [-77.021884, 38.889563],
      [-77.019824, 38.892368]
    ]
  }
}'
lawn_line_distance(line, 'kilometers')
lawn_line_distance(line, 'miles')
lawn_line_distance(line, 'radians')
lawn_line_distance(line, 'degrees')
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bbox}}, \code{\link{lawn_bearing}},
  \code{\link{lawn_center_of_mass}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}}, \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_pt2line_distance}},
  \code{\link{lawn_square}}
}
\concept{measurements}
