% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_offset.R
\name{lawn_line_offset}
\alias{lawn_line_offset}
\title{Offset a linestring}
\usage{
lawn_line_offset(line, distance, units, lint = FALSE)
}
\arguments{
\item{line}{Line to measure, a \link{data-LineString}.}

\item{distance}{(integer/numeric) Distance along the line.}

\item{units}{Can be degrees, radians, miles, kilometers, inches,
yards, meters}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-LineString}
}
\description{
Takes a \link{data-LineString} and returns a \link{data-LineString} at offset by
the specified distance.
}
\examples{
line <- '{
  "type": "Feature",
  "properties": {
    "stroke": "#F00"
  },
  "geometry": {
    "type": "LineString",
    "coordinates": [[-83, 30], [-84, 36], [-78, 41]]
  }
}'

lawn_line_offset(line, 2, 'miles')
lawn_line_offset(line, 200, 'miles')
lawn_line_offset(line, 0.5, 'radians')
lawn_line_offset(line, 4, 'yards')


line <- '{
    "type": "LineString",
    "coordinates": [[-83, 30], [-84, 36], [-78, 41]]
}'
lawn_line_offset(line, 4, 'yards')
}
