% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureof.R
\name{lawn_featureof}
\alias{lawn_featureof}
\title{Enforce expectations about types of Feature inputs}
\usage{
lawn_featureof(x, type, name, lint = FALSE)
}
\arguments{
\item{x}{a \link{data-Feature} with an expected geometry type. required.}

\item{type}{(character) expected GeoJSON type. required.}

\item{name}{(character) name of calling function. required.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
nothing if no problems - error message if a problem
}
\description{
Enforce expectations about types of Feature inputs
}
\examples{
# all okay
x <- "{ type: 'Feature', properties: {}, geometry: { type: 'Point',
  coordinates: [10, 50] } }"
lawn_featureof(x, 'Point', 'foobar')

# error
# lawn_featureof(x, 'MultiPoint', 'foobar')
}
\seealso{
Other invariant: \code{\link{lawn_collectionof}},
  \code{\link{lawn_geosjontype}}
}
