% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/line_slice.R
\name{lawn_line_slice}
\alias{lawn_line_slice}
\title{Slice a line given two points}
\usage{
lawn_line_slice(point1, point2, line, lint = FALSE)
}
\arguments{
\item{point1}{Starting point}

\item{point2}{Stopping point}

\item{line}{Line to slice}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a \code{\link{data-LineString}}
}
\description{
Takes a line, a start Point, and a stop point and returns the line in
between those points
}
\examples{
start <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [-77.029609, 38.881946]
  }
}'
stop <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [-77.021884, 38.889563]
  }
}'
line <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "LineString",
   "coordinates": [
     [-77.031669, 38.878605],
     [-77.029609, 38.881946],
     [-77.020339, 38.884084],
     [-77.025661, 38.885821],
     [-77.021884, 38.889563],
     [-77.019824, 38.892368]
    ]
  }
}'
lawn_line_slice(start, stop, line)

# lint input objects
lawn_line_slice(start, stop, line, TRUE)
}

