% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distance.R
\name{lawn_distance}
\alias{lawn_distance}
\title{Distance between two points}
\usage{
lawn_distance(from, to, units = "kilometers", lint = FALSE)
}
\arguments{
\item{from}{Origin point}

\item{to}{Destination point}

\item{units}{(character) Can be degrees, radians, miles, or kilometers}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
Single numeric value
}
\description{
Calculates the distance between two \code{\link{data-Point}}'s in degress,
radians, miles, or kilometers. Uses the
\href{http://en.wikipedia.org/wiki/Haversine_formula}{Haversine formula}
to account for global curvature.
}
\examples{
from <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "Point",
   "coordinates": [-75.343, 39.984]
 }
}'
to <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [-75.534, 39.123]
  }
}'
lawn_distance(from, to)
}
\seealso{
Other measurements: \code{\link{lawn_along}};
  \code{\link{lawn_area}}; \code{\link{lawn_bbox_polygon}};
  \code{\link{lawn_bearing}}; \code{\link{lawn_center}};
  \code{\link{lawn_centroid}};
  \code{\link{lawn_destination}};
  \code{\link{lawn_envelope}}; \code{\link{lawn_extent}};
  \code{\link{lawn_line_distance}};
  \code{\link{lawn_midpoint}};
  \code{\link{lawn_point_on_surface}};
  \code{\link{lawn_size}}; \code{\link{lawn_square}}
}

