% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/concave.R
\name{lawn_concave}
\alias{lawn_concave}
\title{Concave hull polygon}
\usage{
lawn_concave(points, maxEdge = 1, units = "miles", lint = FALSE)
}
\arguments{
\item{points}{input points in a \code{\link{data-FeatureCollection}}}

\item{maxEdge}{the size of an edge necessary for part of the hull to
become concave (in miles)}

\item{units}{used for maxEdge distance (miles [default] or kilometers)}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{\link{data-Polygon}} a concave hull
}
\description{
Takes a set of \code{\link{data-Point}}'s and returns a concave hull polygon.
Internally, this implements a Monotone chain algorithm
}
\examples{
points <- '{
  "type": "FeatureCollection",
  "features": [
    {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.601226, 44.642643]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.591442, 44.651436]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.580799, 44.648749]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.573589, 44.641788]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.587665, 44.64533]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.595218, 44.64765]
      }
    }
    ]
}'
lawn_concave(points, 1)
}
\seealso{
Other transformations: \code{\link{lawn_bezier}};
  \code{\link{lawn_buffer}}; \code{\link{lawn_convex}};
  \code{\link{lawn_erase}}; \code{\link{lawn_intersect}};
  \code{\link{lawn_merge}}; \code{\link{lawn_simplify}};
  \code{\link{lawn_union}}
}

