% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score2.R
\name{score2}
\alias{score2}
\alias{score2.lm}
\alias{score2.gls}
\alias{score2.lme}
\alias{score2.lvmfit}
\title{Compute the Score Directly from the Gaussian Density}
\usage{
score2(object, ...)

\method{score2}{lm}(object, indiv = TRUE, return.vcov.param = FALSE, ...)

\method{score2}{gls}(object, cluster, p = NULL, data = NULL, indiv = TRUE,
  return.vcov.param = FALSE, ...)

\method{score2}{lme}(object, cluster, p = NULL, data = NULL, indiv = TRUE,
  return.vcov.param = FALSE, ...)

\method{score2}{lvmfit}(object, p = NULL, data = NULL, indiv = TRUE,
  return.vcov.param = FALSE, ...)
}
\arguments{
\item{object}{a linear model or a latent variable model.}

\item{...}{arguments to be passed to \code{\link{residuals2}}}

\item{indiv}{[logical] should the score relative to each observation be exported?
Otherwise the total score (i.e. sum over all observations) will be exported.}

\item{return.vcov.param}{[logical] should the variance covariance matrix of the coefficients be included in the output?}

\item{cluster}{[vector] the grouping variable relative to which the observations are iid.
Only required for \code{gls} models with no correlation argument.}

\item{p}{[numeric vector, optional] vector of coefficients at which to evaluate the score.}

\item{data}{[data.frame, optional] data set.}
}
\value{
A matrix.
}
\description{
Compute the score directly from the gaussian density.
}
\details{
The log-likelihood of a lvm can written:
\deqn{
  l(\theta|Y,X) = \sum_{i=1}^{n} - \frac{p}{2} log(2\pi) - \frac{1}{2} log|\Omega(\theta))| - \frac{1}{2} (Y_i-\mu_i(\theta)) \Omega^{-1} (Y_i-\mu_i(\theta))^t
}
So the score is:
\deqn{
  s(\theta|Y,X) = \sum_{i=1}^{n}
- \frac{1}{2} tr(\Omega(\theta)^{-1} \frac{\partial \Omega(\theta)}{\partial \theta})
+  \frac{\partial \mu_i(\theta)}{\partial \theta} \Omega^{-1} (Y_i-\mu_i(\theta))^t 
+ \frac{1}{2} (Y_i-\mu_i(\theta)) \Omega^{-1} \frac{\partial \Omega(\theta)}{\partial \theta} \Omega^{-1} (Y_i-\mu_i(\theta))^t
}
with:
\deqn{ \frac{\partial \mu_i(\beta)}{\partial \nu} = 1 }
\deqn{ \frac{\partial \mu_i(\beta)}{\partial K} = X_i }
\deqn{ \frac{\partial \mu_i(\beta)}{\partial \alpha} = (1-B)^{-1}\Lambda }
\deqn{ \frac{\partial \mu_i(\beta)}{\partial \Gamma} = X_i(1-B)^{-1}\Lambda }
\deqn{ \frac{\partial \mu_i(\beta)}{\partial \lambda} = (\alpha + X_i \Gamma)(1-B)^{-1}\delta_{\lambda \in \Lambda} }
\deqn{ \frac{\partial \mu_i(\beta)}{\partial b} = (\alpha + X_i \Gamma)(1-B)^{-1}\delta_{b \in B}(1-B)^{-1}\Lambda }
and:
\deqn{ \frac{\partial \Omega(\beta)}{\partial \psi} = \Lambda^t (1-B)^{-t} \delta_{\psi \in \Psi} (1-B) \Lambda }
\deqn{ \frac{\partial \Omega(\beta)}{\partial \sigma} = \delta_{\sigma \in \Sigma} }
\deqn{ \frac{\partial \Omega(\beta)}{\partial \lambda} = \delta_{\lambda \in \Lambda} (1-B)^{-t} \Psi (1-B)^{-1} \Lambda + \Lambda^t (1-B)^{-t} \Psi (1-B)^{-1} \delta_{\lambda \in \Lambda} }
\deqn{ \frac{\partial \Omega(\beta)}{\partial b} = \Lambda^t (1-B)^{-t} \delta_{b \in B} (1-B)^{-t} \Psi (1-B)^{-1} \Lambda - \Lambda^t (1-B)^{-t} \Psi (1-B)^{-1} \delta_{b \in B} (1-B)^{-1} \Lambda}
}
\examples{

m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m,sim(m,1e2))
score2(e)

}
\concept{
small sample inference
}
