% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsep.R
\name{dsep.lvm}
\alias{dsep}
\alias{dsep.lvm}
\title{Check d-separation criterion}
\usage{
\method{dsep}{lvm}(object, x, cond = NULL, return.graph = FALSE, ...)
}
\arguments{
\item{object}{lvm object}

\item{x}{Variables for which to check for conditional independence}

\item{cond}{Conditioning set}

\item{return.graph}{If TRUE the moralized ancestral graph with the
conditioning set removed is returned}

\item{...}{Additional arguments to lower level functions}
}
\description{
Check for conditional independence (d-separation)
}
\details{
The argument 'x' can be given as a formula, e.g.  x~y|z+v
    or ~x+y|z+v With everything on the rhs of the bar defining the
    variables on which to condition on.
}
\examples{
m <- lvm(x5 ~ x4+x3, x4~x3+x1, x3~x2, x2~x1)
if (interactive()) {
plot(m,layoutType='neato')
}
dsep(m,x5~x1|x2+x4)
dsep(m,x5~x1|x3+x4)
dsep(m,~x1+x2+x3|x4)

}

