% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R, R/model.R
\name{responseVariable}
\alias{responseVariable}
\alias{responseVariable,lcMethod-method}
\alias{responseVariable,lcModel-method}
\title{Extract response variable}
\usage{
responseVariable(object, ...)

\S4method{responseVariable}{lcMethod}(object, ...)

\S4method{responseVariable}{lcModel}(object, ...)
}
\arguments{
\item{object}{The object.}

\item{...}{Not used.}
}
\value{
A nonempty string, as \code{character}.
}
\description{
Extracts the response variable from the given \code{object}.

Get the response variable, i.e., the dependent variable.
}
\details{
If the \code{lcMethod} object specifies a \code{formula} argument, then the response is extracted from the response term of the formula.
}
\examples{
method <- lcMethodLMKM(Y ~ Time)
responseVariable(method) # "Y"
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
responseVariable(model) # "Y"
}
\seealso{
Other variables: 
\code{\link{idVariable}()},
\code{\link{timeVariable}()}
}
\concept{variables}
