% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{converged}
\alias{converged}
\alias{converged,lcModel-method}
\title{Check model convergence}
\usage{
\S4method{converged}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} to check for convergence.}

\item{...}{Additional arguments.}
}
\value{
Either \code{logical} indicating convergence, or a \code{numeric} status code.
}
\description{
Check convergence of the fitted \code{lcModel} object.
The default implementation returns \code{NA}.
}
\section{Implementation}{

Classes extending \code{lcModel} can override this method to return a convergence status or code.
\preformatted{
setMethod("converged", "lcModelExt", function(object, ...) {
  # return convergence code
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 2)
converged(model)
}
\seealso{
Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
