% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{qqPlot}
\alias{qqPlot}
\alias{qqPlot,lcModel-method}
\title{Quantile-quantile plot}
\usage{
\S4method{qqPlot}{lcModel}(object, byCluster = FALSE, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{byCluster}{Whether to plot the Q-Q line per cluster}

\item{...}{Additional arguments passed to \code{\link[qqplotr:stat_qq_band]{qqplotr::geom_qq_band()}}, \code{\link[qqplotr:stat_qq_line]{qqplotr::stat_qq_line()}}, and \code{\link[qqplotr:stat_qq_point]{qqplotr::stat_qq_point()}}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the quantile-quantile (Q-Q) plot for the fitted \code{lcModel} object. This function is based on the \pkg{qqplotr} package.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)

if (require("ggplot2") && require("qqplotr")) {
  qqPlot(model)
}
}
\seealso{
\link{residuals.lcModel} \link{metric} \link{plotClusterTrajectories}
}
