% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-evaluation.R
\name{logLik.lcModel}
\alias{logLik.lcModel}
\title{Extract the log-likelihood of a lcModel}
\usage{
\method{logLik}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Additional arguments.}
}
\value{
A \code{numeric} with the computed log-likelihood. If unavailable, \code{NA} is returned.
}
\description{
Extract the log-likelihood of a lcModel
}
\details{
The default implementation checks for the existence of the \code{logLik()} function for the internal model, and returns the output, if available.
}
\examples{
data(latrendData)

if (rlang::is_installed("lcmm")) {
  method <- lcMethodLcmmGBTM(
    fixed = Y ~ Time,
    mixture = ~ 1,
    id = "Id",
    time = "Time",
    nClusters = 3
  )
  gbtm <- latrend(method, data = latrendData)
  logLik(gbtm)
}
}
\seealso{
\link[stats:logLik]{stats::logLik} \link{metric}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
