% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{converged}
\alias{converged}
\alias{converged,lcModel-method}
\title{Check model convergence}
\usage{
\S4method{converged}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} to check for convergence.}

\item{...}{Additional arguments.}
}
\value{
Either \code{logical} indicating convergence, or a \code{numeric} status code.
}
\description{
Check convergence of the fitted \code{lcModel} object.
The default implementation returns \code{NA}.
}
\section{Implementation}{

Classes extending \code{lcModel} can override this method to return a convergence status or code.
\preformatted{
setMethod("converged", "lcModelExt", function(object, ...) {
  # return convergence code
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 2)
converged(model)
}
\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
