% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R, R/models.R
\name{estimationTime}
\alias{estimationTime}
\alias{estimationTime,lcModel-method}
\alias{estimationTime,lcModels-method}
\alias{estimationTime,list-method}
\title{Get the model estimation time}
\usage{
\S4method{estimationTime}{lcModel}(object, unit = "secs", ...)

\S4method{estimationTime}{lcModels}(object, unit = "secs", ...)

\S4method{estimationTime}{list}(object, unit = "secs", ...)
}
\arguments{
\item{object}{The list of \code{lcModel} objects.}

\item{unit}{The time unit in which the estimation time should be outputted.
By default, estimation time is in seconds.
For accepted units, see \link[base:difftime]{base::difftime}.}

\item{...}{Additional arguments.}
}
\value{
A \code{numeric} representing the model estimation time, in the specified unit.
}
\description{
Get the estimation time of the model, determined by the time taken for the associated \code{\link[=fit]{fit()}} function to finish.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

estimationTime(model)
estimationTime(model, unit = 'mins')
estimationTime(model, unit = 'days')
}
