% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model.frame.lcModel}
\alias{model.frame.lcModel}
\title{Extract model training data}
\usage{
\method{model.frame}{lcModel}(formula, ...)
}
\arguments{
\item{formula}{The \code{lcModel} object.}

\item{...}{Additional arguments.}
}
\value{
A \code{data.frame} containing the variables used by the model.
}
\description{
See \code{\link[stats:model.frame]{stats::model.frame()}} for more details.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
lmkm <- latrend(method, data = latrendData)
model.frame(lmkm)
}
\seealso{
\link[stats:model.frame]{stats::model.frame} \link{model.data.lcModel}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
