% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{meltRepeatedMeasures}
\alias{meltRepeatedMeasures}
\title{Convert a repeated measures data matrix to a data.frame}
\usage{
meltRepeatedMeasures(
  data,
  response,
  id = getOption("latrend.id"),
  time = getOption("latrend.time"),
  ids = rownames(data),
  times = colnames(data),
  as.data.table = FALSE
)
}
\arguments{
\item{data}{The \code{matrix} containing a trajectory on each row.}

\item{response}{The response column name.}

\item{id}{The id column name.}

\item{time}{The time column name.}

\item{ids}{A \code{vector} specifying the id names. Should match the number of rows of \code{data}.}

\item{times}{A \code{numeric} \code{vector} specifying the times of the measurements. Should match the number of columns of \code{data}.}

\item{as.data.table}{Whether to return the result as a \code{data.table}, or a \code{data.frame} otherwise.}
}
\value{
A \code{data.table} or \code{data.frame} containing the repeated measures.
}
\description{
Convert a repeated measures data matrix to a data.frame
}
