% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{ghostconvert}
\alias{ghostconvert}
\title{Call Ghostscript.}
\usage{
ghostconvert(
  x,
  y = file.path(gdir, out),
  gdir = dirname(x),
  out = sub("\\\\.[^.]+$", paste0(if (multipage) multifix else NULL, ".", suffix),
    basename(x)),
  gs_cmd = "",
  device = "pngalpha",
  multipage = FALSE,
  multifix = "-\%03d",
  suffix = "png",
  antialias = 4,
  resolution = 300,
  replace = TRUE,
  other = "",
  ...
)
}
\arguments{
\item{x}{path for file to be converted}

\item{y}{path for output file}

\item{gdir}{directory for png output}

\item{out}{filename for output file}

\item{gs_cmd}{passed to \code{\link[tools]{find_gs_cmd}}; perhaps 'gs' or 'gswin32c' or 'mgs' (from Miktex)}

\item{device}{output device type}

\item{multipage}{whether to convert multiple pages}

\item{multifix}{a filename suffix when converting multiple pages}

\item{suffix}{file extension for output}

\item{antialias}{font antialiasing}

\item{resolution}{raster image resolution}

\item{replace}{whether to delete \code{x} if successful}

\item{other}{other arguments to ghostscript}

\item{...}{ignored}
}
\value{
the name of the file created
}
\description{
Call Ghostscript, converting by default from PDF to PNG.
}
\examples{
\dontrun{
pdf <- as.pdf(head(Theoph),dir = tempdir())
png <- ghostconvert(pdf, gs_cmd = 'mgs')
browseURL(png)
}
}
