% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular.R
\name{as.tabular}
\alias{as.tabular}
\alias{as.tabular.data.frame}
\alias{as.tabular.table}
\alias{as.tabular.matrix}
\title{Coerce to tabular}
\usage{
as.tabular(x, ...)

\method{as.tabular}{data.frame}(x, rules = c(2, 1, 1), walls = 0,
  grid = FALSE, rowgroups = factor(rownames(x)),
  colgroups = factor(names(x)), rowbreaks = if (grid) breaks(rowgroups) else
  0, colbreaks = if (grid) breaks(colgroups) else 0, rowgrouprule = 0,
  colgrouprule = 0, rowcolors = NULL, rowgrouplabel = " ",
  charjust = "left", numjust = "right", justify = ifelse(sapply(x,
  is.numeric), numjust, charjust), decimal.mark = getOption("OutDec"),
  colwidth = NA, paralign = "top", na = "", verbatim = ifelse(sapply(x,
  is.numeric), TRUE, FALSE), escape = "#", trim = TRUE, source = NULL,
  file = NULL, source.label = "source: ", file.label = "file: ",
  basefile = FALSE, tabularEnvironment = "tabular",
  footnote.size = "tiny", ...)

\method{as.tabular}{table}(x, ...)

\method{as.tabular}{matrix}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}

\item{rules}{numeric; will be recycled to length 3.  indicates number of horizontal lines above and below the header, and below the last row.}

\item{walls}{numeric, recycled to length 2.  Number of vertical lines on left and right of table.}

\item{grid}{logical, whether to have lines between rows and columns}

\item{rowgroups}{a vector as long as nrow(x), non-repeats trigger horizontal lines}

\item{colgroups}{a vector as long as names(x), non-repeats trigger vertical lines}

\item{rowbreaks}{numeric: a manual way to specify numbers of lines between rows (ignores grid and rowgroups)}

\item{colbreaks}{numeric: a manual way to specify numbers of lines between columns (ignores grid and colgroups)}

\item{rowgrouprule}{number of lines to set off row group column, if rowgroups supplied as character}

\item{colgrouprule}{number of lines to set off col group header, if colgroups supplied as character}

\item{rowcolors}{character vector of color names, recycled as necessary to color all rows (NULL: no color)}

\item{rowgrouplabel}{character string (at least one character) to label rowgroup column}

\item{charjust}{default justification for character columns}

\item{numjust}{default justification for numeric columns}

\item{justify}{manual specification of column justifications: left, right, center, or decimal (vector as long as ncol(x))}

\item{decimal.mark}{passed to \code{\link{format.data.frame}}}

\item{colwidth}{manual specification of column width. (vector of length ncol(x).) Overrides \code{justify} where not NA.}

\item{paralign}{used with colwidth to align paragraphs: top, middle, or bottom.}

\item{na}{string to replace NA elements}

\item{verbatim}{whether to use verbatim environment for numeric fields.  Makes sense for decimal justification; interacts with \code{trim} and \code{justify}.}

\item{escape}{symbol used by `verb' command as delimiter.  A warning is issued if it is found in non-NA text.}

\item{trim}{passed to the format command: true by default, so that alignment is the responsibility of just the tabular environment arguments}

\item{source}{optional source attribution}

\item{file}{optional file name}

\item{source.label}{optional text to preceed source if specified}

\item{file.label}{optional text to preceed file if specified}

\item{basefile}{if TRUE, strip path from file for display purposes}

\item{tabularEnvironment}{default \code{tabular}; consider also \code{longtable}}

\item{footnote.size}{font size for source and file attributions}
}
\value{
tabular
}
\description{
Coerces to tabular.  Generic, with methods for data.frame, table, and matrix.

Coerces to tabular from data.frame. Extra arguments passed to \code{\link{format.data.frame}}.

Coerces to tabular from table.

Coerces to tabular from matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: data.frame method

\item \code{table}: table method

\item \code{matrix}: matrix method
}}

\examples{
as.tabular(head(Theoph))
as.tabular(table(1:3,4:6))
as.tabular(head(Theoph,source='foo/bar',footnote.size='huge'))
\dontrun{as.pdf(head(Theoph))}

}
\seealso{
\code{\link{as.ltable}}
}
