% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.fixed.R
\name{receivercov-ergmTerm}
\alias{receivercov-ergmTerm}
\alias{InitErgmTerm.receivercov}
\title{Receiver covariate effect}
\usage{
# binary: receivercov(attrname, force.factor=FALSE, mean=0, var=9)

# valued: receivercov(attrname, force.factor=FALSE, mean=0, var=9)
}
\arguments{
\item{attrname}{a character string giving the name of an attribute
in the network's vertex attribute list.}

\item{force.factor}{logical, indicating if \code{attrname}'s value
should be interpreted as categorical even if numeric.}

\item{mean, var}{prior mean and variance.}
}
\description{
\emph{Deprecated for networks without self-loops. Use
\code{\link{nodeicov-ergmTerm}},
\code{\link{nodeifactor-ergmTerm}},
\code{\link{nodecov-ergmTerm}} or
\code{\link{nodefactor-ergmTerm}} instead.}

If the attribute is numeric, this term adds one covariate to the
model equaling \code{attrname(i)}. If the attribute is not
numeric or \code{force.factor==TRUE}, this term adds \eqn{p-1}
covariates to the model, where \eqn{p} is the number of unique
values of \code{attrname}.  The \eqn{k}th such covariate has the
value \code{attrname(i) == value(k+1)}, where \code{value(k)} is
the \eqn{k}th smallest unique value of the \code{attrname}
attribute. This term only makes sense if the network is directed.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[=ergm]{ergm()}} will result in an error.
}
\note{
This term can only be used with directed networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "receivercov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
\concept{loops}
