% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatgpt.R
\name{gpt_prompter}
\alias{gpt_prompter}
\title{Structured Prompt Builder for LLM (ChatGPT)}
\usage{
gpt_prompter(
  instruction = NULL,
  input = NULL,
  context = NULL,
  output = NULL,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{instruction, input, context, output}{Character or vector.
You do not need all the four elements for a prompt and the
format depends on the task at hand.}

\item{quiet}{Boolean. Should the written prompt be printed or not?}

\item{...}{Additional parameters. You can pass \code{cols} parameter to
explicitly set column names.}
}
\value{
(Invisible) list with written prompt and elements provided.
}
\description{
Build standard prompts to get the right outcomes using the four theoretical
elements required to build standard and cleaner asks: instruction, input, context,
and output. Inspired by the
\href{https://www.promptingguide.ai/}{Prompt Engineering Guide} free guide.
Remember to start simple and be very specific to get exactly what you need.
}
\section{Elements of a Prompt}{

\describe{
  \item{Instruction}{a specific task or instruction you want the model to perform.
  It usually starts with a verb given its an instruction.}
  \item{Input}{input data, elements or question that we are interested to find a response for,}
  \item{Context}{external information, additional context or references to steer
  the model to better responses.}
  \item{Output}{type or format of the output.}
}
}

\examples{
# A simple formatted table with data
# Note: I mostly use output = "table" and enabled an auxiliary enrichment prompt
(p <- gpt_prompter(instruction = "Capitals of the world", output = "table"))

# Classify
p <- gpt_prompter(
  instruction = "For each of the inputs, classify using only the options in context",
  input = c("Molecule", "Elephant", "Milky Way", "Cat", "Planet Earth"),
  context = c("Big", "Medium", "Small"),
  output = "table",
  # This cols parameter is auxiliary
  cols = c("Input", "Category"),
  quiet = FALSE)

# Tag all categories that apply
p <- gpt_prompter(
  instruction = paste("For each of the inputs, provide which of the",
                      "context values apply as correct tags using TRUE/FALSE"),
  input = c("I love chocolate", "I hate chocolate", "I like Coke", "Who am I?", "T-REX"),
  context = c("food", "positive", "negative", "beverage"),
  output = "table",
  quiet = FALSE)

# Extract information from strings
p <- gpt_prompter(
  instruction = "For each of the inputs, extract each of the information asked in context",
  input = c("My mail is 123@test.com", "30 Main St, NY, USA", "+82 2-312-3456", "$1.5M"),
  context = c("email", "full state name", "country of phone", "full non-abbreviated number"),
  output = "table",
  cols = c("Input", "Element_to_extract", "Value"),
  quiet = FALSE)

# Translate to several languages
p <- gpt_prompter(
  instruction = "For each of the inputs, translate to the respective languages in context",
  input = rep("I love you with all my heart", 5),
  context = c("spanish", "chinese", "japanese", "russian", "german"),
  output = "table",
  cols = c("Input", "Language", "Translation"),
  quiet = FALSE)

# Format date values
p <- gpt_prompter(
  instruction = paste("For each of the inputs,",
                      "standardize and format all values to the format in context"),
  input = c("March 27th, 2021", "12-25-2023 3:45PM", "01.01.2000", "29 Feb 92"),
  context = "ISO Date getting rid of time stamps",
  output = "table",
  cols = c("Input", "Formatted"),
  quiet = FALSE)

# Convert units
p <- gpt_prompter(
  instruction = paste("For each of the inputs,",
                      "provide new converted values using the units in context"),
  input = c("50C", "300K", "100F", "0F", "32C", "0K"),
  context = "Fahrenheit",
  output = "table",
  cols = c("Input", "Original_Unit", "Total_Value", "Converted_Value", "New_Unit"),
  quiet = FALSE)
  
# Read a text and answer a question related to it
gpt_prompter(instruction = "read",
  context = "Long text here",
  input = "Question here")$prompt
}
\seealso{
Other ChatGPT: 
\code{\link{gpt_ask}()}
}
\concept{ChatGPT}
