% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{corr_var}
\alias{corr_var}
\alias{plot.corr_var}
\title{Correlation between variable and dataframe}
\usage{
corr_var(
  df,
  var,
  ignore = NULL,
  trim = 0,
  clean = FALSE,
  plot = TRUE,
  top = NA,
  ceiling = 1,
  max_pvalue = 1,
  limit = 10,
  ranks = FALSE,
  zeroes = FALSE,
  save = FALSE,
  quiet = FALSE,
  ...
)

\method{plot}{corr_var}(x, var, max_pvalue = 1, top = NA, limit = NULL, ...)
}
\arguments{
\item{df}{Dataframe. It doesn't matter if it's got non-numerical
columns: they will be filtered.}

\item{var}{Variable. Name of the variable to correlate. Note that if the
variable \code{var} is not numerical, 1. you may define which category to select
from using `var_category`; 2. You may have to add \code{redundant = TRUE} to
enable all categories (instead of \code{n-1}).}

\item{ignore}{Character vector. Which columns do you wish to exclude?}

\item{trim}{Integer. Trim words until the nth character for
categorical values (applies for both, target and values)}

\item{clean}{Boolean. Use lares::cleanText for categorical values (applies
for both, target and values)}

\item{plot}{Boolean. Do you wish to plot the result? If set to TRUE, the
function will return only the plot and not the result's data}

\item{top}{Integer. If you want to plot the top correlations,
define how many}

\item{ceiling}{Numeric. Remove all correlations above... Range: (0-1]}

\item{max_pvalue}{Numeric. Filter non-significant variables. Range (0, 1]}

\item{limit}{Integer. Limit one hot encoding to the n most frequent
values of each column. Set to \code{NA} to ignore argument.}

\item{ranks}{Boolean. Add ranking numbers?}

\item{zeroes}{Do you wish to keep zeroes in correlations too?}

\item{save}{Boolean. Save output plot into working directory}

\item{quiet}{Boolean. Keep quiet? If not, show messages}

\item{...}{Additional parameters passed to \code{corr} and \code{cor.test}}

\item{x}{corr_var object}
}
\value{
data.frame. With variables, correlation and p-value results
for each feature, arranged by descending absolute correlation value.
}
\description{
This function correlates a whole dataframe with a single feature. It
automatically runs \code{ohse} (one-hot-smart-encoding) so no need to input
only numerical values.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset

corr_var(dft, Survived, method = "spearman", plot = FALSE, top = 10)

# With plots, results are easier to compare:

# Correlate Survived with everything else and show only significant results
dft \%>\% corr_var(Survived_TRUE, max_pvalue = 0.05)

# Top 15 with less than 50\% correlation and show ranks
dft \%>\% corr_var(Survived_TRUE, ceiling = .6, top = 15, ranks = TRUE)
}
\seealso{
Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}

Other Correlations: 
\code{\link{corr}()},
\code{\link{corr_cross}()}
}
\concept{Correlations}
\concept{Exploratory}
