% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache_write}
\alias{cache_write}
\alias{cache_read}
\alias{cache_exists}
\alias{cache_clear}
\title{Cache Save and Load (Write and Read)}
\usage{
cache_write(
  data,
  base = "temp",
  cache_dir = getOption("LARES_CACHE_DIR"),
  ask = FALSE,
  quiet = FALSE
)

cache_read(
  base,
  cache_dir = getOption("LARES_CACHE_DIR"),
  ask = FALSE,
  quiet = FALSE
)

cache_exists(
  base = NULL,
  cache_dir = getOption("LARES_CACHE_DIR"),
  filename = NULL
)

cache_clear(cache_dir = getOption("LARES_CACHE_DIR"))
}
\arguments{
\item{data}{Object}

\item{base}{Character vector. Unique name for your cache file. You can pass
a character vector with multiple elements that will be concatenated.}

\item{cache_dir}{Character. Where do you want to save you cache files?
By default they'll be stored on \code{tempdir()} but you can change it
using this parameter or setting a global option called \code{"LARES_CACHE_DIR"}.}

\item{ask}{Boolean. If cache exists, when reading: (interactive) ask the user 
if the cache should be used to proceed or ignored; when writing, (interactive)
ask the user if the cache should be overwritten.}

\item{quiet}{Boolean. Keep quiet? If not, message will be shown.}

\item{filename}{Character. File name to check existence.}
}
\value{
\code{cache_write}. No return value, called for side effects.

\code{cache_read}. R object. Data from cache file or NULL if no cache found.

\code{cache_exists}. Boolean. Result of \code{base} existence.

\code{cache_clear}. Invisible vector containing cache file names removed.
}
\description{
This function lets the user save and load a cache of any R object to
improve timings and UX.
}
\examples{
x = list(a = 1, b = 2:4)
base <- c(as.character(Sys.Date()), "A","B","C")
cache_write(x, base)
cache_read(base, ask = FALSE)
}
\concept{Cache}
