% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{updateReproSexProb}
\alias{updateReproSexProb}
\title{Update the probability of sexual reproduction}
\usage{
updateReproSexProb(params, vec)
}
\arguments{
\item{params}{a LandsepiParams object}

\item{vec}{a vector of size TimeParam$nTSpY +1 (season end) with the probabilities
for an infectious host to reproduce via sex rather than via cloning at each time step.}
}
\value{
a LandsepiParams object updated
}
\description{
set the probabilities for an infectious host to reproduce via sex rather
than via cloning at every time step.
Note that time parameters must be set before updating sexual reproduction probabilities.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setTime(simul_params, Nyears=10, nTSpY=120)
simul_params <- setPathogen(simul_params, loadPathogen("rust"))
repro_sex_probs <- c(rep(0.0, 120), 1.0)  
simul_params <- updateReproSexProb(simul_params, repro_sex_probs)
simul_params@Pathogen
}
}
