% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setDispersalPathogen}
\alias{setDispersalPathogen}
\title{Set pathogen dispersal}
\usage{
setDispersalPathogen(params, mat)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{mat}{a square matrix giving the probability of pathogen dispersal
from any field of the landscape to any other field.
It can be generated manually, or, alternatively, via \code{\link{loadDispersalPathogen}}.
The size of the matrix must match the number of fields in the landscape, and lines of the matrix must sum
to 1.}
}
\value{
a LandsepiParam object.
}
\description{
Updates a LandsepiParams object with a pathogen dispersal matrix.
}
\details{
See tutorial (vignettes) on how to
use your own landscape and compute your own pathogen dispersal kernel.
The disersal matrix a square matrix whose size is the number of fields in the landscape and whose elements are,
for each line i and each column i' the probability that propagules migrate
from field i to field i'.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setLandscape(simul_params, loadLandscape(1))
d <- loadDispersalPathogen(1)
simul_params <- setDispersalPathogen(simul_params, d)
simul_params@DispPatho
}
}
\seealso{
\link{loadDispersalPathogen}
}
