% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setLansdcape}
\alias{setLansdcape}
\alias{setLandscape}
\title{Set the landscape}
\usage{
setLandscape(params, land)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{land}{a landscape as sp or sf object}
}
\value{
a LandsepiParams object.
}
\description{
Updates a LandsepiParams object with a sp or sf object as landscape.
}
\details{
The landscape should be a sp or sf object. Built-in landscape are available using
\code{\link{loadLandscape}}.
See our tutorial (vignettes) for details on how to use your own landscape.
If the landscape contains only polygons, croptypes can be allocated later using
\code{\link{allocateLandscapeCroptypes}}.
Otherwise the landscape has to contain a data.frame specifying for every year, the index
of the croptype cultivated in each polygon.
Each features has a field identified by "year_XX" (XX <- seq(1:Nyears+1)) and containing
the croptype ID.\tabular{llll}{
   Features/fields \tab year_1 \tab year_2 \tab ... year_Nyears+1 \cr
   polygons1 \tab 13 \tab 10 \tab 13 \cr
   polygonsX \tab 2 \tab 1 \tab 2 \cr
}
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setLandscape(simul_params, loadLandscape(1))
simul_params@Landscape
}
}
\seealso{
\link{loadLandscape}
}
