% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_lsm.R
\name{sample_lsm}
\alias{sample_lsm}
\title{sample_lsm}
\usage{
sample_lsm(
  landscape,
  y,
  plot_id = NULL,
  shape = "square",
  size = NULL,
  all_classes = FALSE,
  return_raster = FALSE,
  verbose = TRUE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{y}{2-column matrix with coordinates or sf point geometries.}

\item{plot_id}{Vector with id of sample points. If not provided, sample
points will be labelled 1...n.}

\item{shape}{String specifying plot shape. Either "circle" or "square"}

\item{size}{Approximated size of sample plot. Equals the radius for circles or half of
the side-length for squares in map units. For lines size equals the width of the buffer.}

\item{all_classes}{Logical if NA should be returned for classes not present in some sample plots.}

\item{return_raster}{Logical if the clipped raster of the sample plot should
be returned}

\item{verbose}{Print warning messages.}

\item{progress}{Print progress report.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
tibble
}
\description{
Sample metrics
}
\details{
This function samples the selected metrics in a buffer area (sample plot)
around sample points, sample lines or within provided polygons. The size of the actual
sampled landscape can be different to the provided size due to two reasons.
Firstly, because clipping raster cells using a circle or a sample plot not directly
at a cell center lead to inaccuracies. Secondly, sample plots can exceed the
landscape boundary. Therefore, we report the actual clipped sample plot area relative
in relation to the theoretical, maximum sample plot area e.g. a sample plot only half
within the landscape will have a \code{percentage_inside = 50}. Additionally, if the polygon
representing the sample plot is smaller than the cell size of the raster,
the \code{percentage_inside} may exceed 100\%.Please be aware that the
output is slightly different to all other \code{lsm}-function of \code{landscapemetrics}.

Please be aware that the function behaves differently for POLYGONS and MULTIPOLYGONS.
In the first case, each polygon is used as a singular sample area, while in the second
case all polygons are used as one sample area.

The metrics can be specified by the arguments \code{what}, \code{level}, \code{metric}, \code{name}
and/or \code{type} (combinations of different arguments are possible (e.g.
\verb{level = "class", type = "aggregation metric"}). If an argument is not provided,
automatically all possibilities are selected. Therefore, to get \strong{all}
available metrics, don't specify any of the above arguments.

For all metrics based on distances or areas please make sure your data is valid
using \code{\link{check_landscape}}.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)

# use a matrix
sample_points <- matrix(c(10, 5, 25, 15, 5, 25), ncol = 2, byrow = TRUE)
sample_lsm(landscape, y = sample_points, size = 15, what = "lsm_l_np")

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{calculate_lsm}}
}
