% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_ta.R
\name{lsm_l_ta}
\alias{lsm_l_ta}
\title{TA (landscape level)}
\usage{
lsm_l_ta(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Total area (Area and edge metric)
}
\details{
\deqn{CA = sum(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

TA is an 'Area and edge metric'. The total (class) area sums the area of all patches
in the landscape. It is the area of the observation area.

\subsection{Units}{Hectares}
\subsection{Range}{TA > 0}
\subsection{Behaviour}{Approaches TA > 0 if the landscape is small and increases,
without limit, as the size of the landscape increases.}
}
\examples{
lsm_l_ta(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{sum}}, \cr
\code{\link{lsm_c_ca}}
}
