% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_frac_cv.R
\name{lsm_c_frac_cv}
\alias{lsm_c_frac_cv}
\title{FRAC_CV (class level)}
\usage{
lsm_c_frac_cv(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Coefficient of variation fractal dimension index (Shape metric)
}
\details{
\deqn{FRAC_{CV} = cv(FRAC[patch_{ij}])}
where \eqn{FRAC[patch_{ij}]} equals the fractal dimension index of each patch.

FRAC_CV is a 'Shape metric'. The metric summarises each class
as the Coefficient of variation of the fractal dimension index of all patches
belonging to class i. The fractal dimension index is based on the patch perimeter and
the patch area and describes the patch complexity. The Coefficient of variation is
scaled to the mean and comparable among different landscapes.

\subsection{Units}{None}
\subsection{Range}{FRAC_CV >= 0 }
\subsection{Behaviour}{Equals FRAC_CV = 0 if the fractal dimension index is identical
for all patches. Increases, without limit, as the variation of the fractal dimension
indices increases.}
}
\examples{
lsm_c_frac_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Mandelbrot, B. B. 1977. Fractals: Form, Chance, and Dimension.
San Francisco. W. H. Freeman and Company.
}
\seealso{
\code{\link{lsm_p_frac}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_frac_mn}},
\code{\link{lsm_c_frac_sd}}, \cr
\code{\link{lsm_l_frac_mn}},
\code{\link{lsm_l_frac_sd}},
\code{\link{lsm_l_frac_cv}}
}
