% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_msidi.R
\name{lsm_l_msidi}
\alias{lsm_l_msidi}
\title{MSIDI (landscape level)}
\usage{
lsm_l_msidi(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Modified Simpson's diversity index (Diversity metric)
}
\details{
\deqn{MSIDI = -\ln \sum \limits_{i = 1}^{m} P_{i}^{2}}
where \eqn{P_{i}} is the landscape area proportion of class i.

MSIDI is a 'Diversity metric'.

\subsection{Units}{None}
\subsection{Range}{MSIDI >= 0}
\subsection{Behaviour}{MSIDI = 0 if only one patch is present and increases, without
limit, as the amount of patches with equally distributed landscape proportions increases}
}
\examples{
lsm_l_msidi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Simpson, E. H. 1949. Measurement of diversity. Nature 163:688

Pielou, E. C. 1975. Ecological Diversity. Wiley-Interscience, New York.

Romme, W. H. 1982. Fire and landscapediversity in subalpine forests of
Yellowstone National Park.Ecol.Monogr. 52:199-221
}
\seealso{
\code{\link{lsm_l_sidi}}
}
