% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpad_raster.R
\name{unpad_raster}
\alias{unpad_raster}
\alias{unpad_raster.RasterLayer}
\alias{unpad_raster.RasterStack}
\alias{unpad_raster.RasterBrick}
\alias{unpad_raster.stars}
\alias{unpad_raster.list}
\alias{unpad_raster.matrix}
\title{unpad_raster}
\usage{
unpad_raster(landscape, unpad_raster_cells, return_raster, to_disk)

\method{unpad_raster}{RasterLayer}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = TRUE,
  to_disk = getOption("to_disk", default = FALSE)
)

\method{unpad_raster}{RasterStack}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = TRUE,
  to_disk = getOption("to_disk", default = FALSE)
)

\method{unpad_raster}{RasterBrick}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = TRUE,
  to_disk = getOption("to_disk", default = FALSE)
)

\method{unpad_raster}{stars}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = TRUE,
  to_disk = getOption("to_disk", default = FALSE)
)

\method{unpad_raster}{list}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = TRUE,
  to_disk = getOption("to_disk", default = FALSE)
)

\method{unpad_raster}{matrix}(
  landscape,
  unpad_raster_cells = 1,
  return_raster = FALSE,
  to_disk = getOption("to_disk", default = FALSE)
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{unpad_raster_cells}{Number of rows and columns added}

\item{return_raster}{If false, matrix is returned}

\item{to_disk}{Logical argument, if FALSE results of get_patches are hold
in memory. If true, unpad_raster writes temporary files and hence, does not hold
everything in memory. Can be set with a global option, e.g. \code{option(to_disk = TRUE)}.}
}
\value{
raster
}
\description{
Adding padding to raster
}
\details{
Removes equally (in all four directions) additional cells around the raster
}
\examples{
lsm_padded <- pad_raster(landscape, pad_raster_cells = 2, pad_raster_value = -1)
unpad_raster(lsm_padded[[1]], unpad_raster_cells = 2)

}
\keyword{internal}
