% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_patches.R
\name{show_patches}
\alias{show_patches}
\alias{show_patches.RasterLayer}
\alias{show_patches.RasterStack}
\alias{show_patches.RasterBrick}
\alias{show_patches.stars}
\alias{show_patches.list}
\title{Show patches}
\usage{
show_patches(landscape, class, directions, labels, nrow, ncol)

\method{show_patches}{RasterLayer}(
  landscape,
  class = "global",
  directions = 8,
  labels = TRUE,
  nrow = NULL,
  ncol = NULL
)

\method{show_patches}{RasterStack}(
  landscape,
  class = "global",
  directions = 8,
  labels = TRUE,
  nrow = NULL,
  ncol = NULL
)

\method{show_patches}{RasterBrick}(
  landscape,
  class = "global",
  directions = 8,
  labels = TRUE,
  nrow = NULL,
  ncol = NULL
)

\method{show_patches}{stars}(
  landscape,
  class = "global",
  directions = 8,
  labels = TRUE,
  nrow = NULL,
  ncol = NULL
)

\method{show_patches}{list}(
  landscape,
  class = "global",
  directions = 8,
  labels = TRUE,
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{landscape}{*Raster object}

\item{class}{How to show the labeled patches: "global" (single map), "all" (every class as facet), or a vector with the specific classes one wants to show (every selected class as facet).}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{labels}{Logical flag indicating whether to print or not to print patch labels.}

\item{nrow, ncol}{Number of rows and columns for the facet.}
}
\value{
ggplot
}
\description{
Show patches
}
\details{
The functions plots the landscape with the patches labeled with the
corresponding patch id.
}
\examples{
show_patches(landscape)
show_patches(landscape, class = c(1, 2))
show_patches(landscape, class = 3, labels = FALSE)

}
