% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_condent.R
\name{lsm_l_condent}
\alias{lsm_l_condent}
\alias{lsm_l_condent.RasterLayer}
\alias{lsm_l_condent.RasterStack}
\alias{lsm_l_condent.RasterBrick}
\alias{lsm_l_condent.stars}
\alias{lsm_l_condent.list}
\title{Conditional entropy (landscape level)}
\usage{
lsm_l_condent(landscape, neighbourhood = 4, ordered = TRUE,
  base = "log2")

\method{lsm_l_condent}{RasterLayer}(landscape, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{lsm_l_condent}{RasterStack}(landscape, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{lsm_l_condent}{RasterBrick}(landscape, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{lsm_l_condent}{stars}(landscape, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{lsm_l_condent}{list}(landscape, neighbourhood = 4,
  ordered = TRUE, base = "log2")
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered.
Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}
}
\value{
tibble
}
\description{
Conditional entropy
}
\details{
Complexity of a landscape pattern configuration.
It measures a only a geometric intricacy (configurational complexity)
of a landscape pattern.
}
\examples{
lsm_l_condent(landscape)

}
\references{
Nowosad J., TF Stepinski. 2018. Information-theoretical approach to measure
landscape complexity. https://doi.org/10.1101/383281
}
\seealso{
\code{\link{lsm_l_ent}},
\code{\link{lsm_l_mutinf}},
\code{\link{lsm_l_joinent}},
}
