% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_area_sd.R
\name{lsm_l_area_sd}
\alias{lsm_l_area_sd}
\alias{lsm_l_area_sd.RasterLayer}
\alias{lsm_l_area_sd.RasterStack}
\alias{lsm_l_area_sd.RasterBrick}
\alias{lsm_l_area_sd.list}
\title{AREA_SD (landscape level)}
\usage{
lsm_l_area_sd(landscape, directions)

\method{lsm_l_area_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_area_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_l_area_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_area_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{SD} = sd(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

AREA_SD is an 'Area and Edge metric'. The metric summarises the landscape
as the standard deviation of all patch in the landscape. The metric describes
the differences among all patches in the landscape.

\subsection{Units}{Hectares}
\subsection{Range}{AREA_SD >= 0}
\subsection{Behaviour}{Equals AREA_SD = 0 if all patches are identical in size.
Increases, without limit, as the variation of patch areas increases.}
}
\examples{
lsm_l_area_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}},
\code{\link{lsm_c_area_cv}} \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_cv}}
}
