% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLine.R
\name{makeLine}
\alias{makeLine}
\title{Create a linear patch (beta version).}
\usage{
makeLine(context, size, direction = NULL, convol = 0.5, spt = NULL,
  bgr = 0, edge = FALSE, rast = FALSE, val = 1)
}
\arguments{
\item{context}{Raster object or matrix, an empty landscape raster or a mask indicating where the patch cannot be generated (see bgr below).}

\item{size}{integer. Size of the patch to be generated, as number of raster cells.}

\item{direction}{numeric. The direction towards which the patch will point and grow, expressed in degrees between 0 and 360.}

\item{convol}{numeric. Level of convolution to be assigned to the patch (default is \code{convol=0.5}). A value
between 0 and 1, where 0 is no convolution at all (basically a straight line) and 1 is maximum convolution (i.e. tends to form a circular patch).}

\item{spt}{integer or matrix. The seed point location around which the patch is generated (a random point is given by default). It can be an integer, as index of the cell in the raster, or a two columns matrix indicating x and y coordinates (an integer vector of length 2 is accepted too).}

\item{bgr}{integer. A single value of background cells, where a patch can be generated (default is zero). Cells/classes which cannot be changed must have a different value.}

\item{edge}{logical. Should the vector of edge cells of the patch be returned?}

\item{rast}{logical. If TRUE returns a Raster object, otherwise a vector of cell numbers where the patch occurs}

\item{val}{integer. The value to be assigned to patch cells, when \code{rast=TRUE}}
}
\value{
A vector of raster cell numbers, or a RasterLayer object if \code{rast=TRUE}. If \code{edge=TRUE} a
list of two vectors is returned: one for the inner raster cells and the second for cells at the edge of the patch.
}
\description{
Create a linear patch, setting direction and convolution. The higher the convolution degree, the weaker the
linear shape (and direction).
% ADD set length instead of size
% FIX values of direction at 0 and 360
% FIX values of convol of 1 and 0
}
\details{
For any values of \code{convol} > 0.8, no big differences are observed noted. Also direction is progressively lost
as convolution increases.
}
\examples{
library(raster)
r <- matrix(0,33,33)
r <- raster(r, xmn=0, xmx=10, ymn=0, ymx=10)
plot(makeLine(r, size=50, spt = 545, direction=45, convol=0.05, rast=TRUE))

}

