% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialTiles.R
\name{getSpatialTiles,Spatial-method}
\alias{getSpatialTiles,Spatial-method}
\alias{getSpatialTiles}
\title{Split a Spatial object into tiles}
\usage{
\S4method{getSpatialTiles}{Spatial}(
  obj,
  block.x,
  block.y = block.x,
  overlap.percent = 0,
  limit.bbox = TRUE,
  return.SpatialPolygons = TRUE
)
}
\arguments{
\item{obj}{output of the GDALinfo.}

\item{block.x}{size of the block in x dimension.}

\item{block.y}{size of the block in y dimension.}

\item{overlap.percent}{optional overlap percent between tiles.}

\item{limit.bbox}{optional bounding box.}

\item{return.SpatialPolygons}{logical specificies whether to return a data frame or Spatial Polygons.}
}
\value{
List of object result of clipping
}
\description{
Split a Spatial object into tiles
}
\examples{
library(sp)
data(meuse.grid)
gridded(meuse.grid) <- ~x+y
tl <- getSpatialTiles(meuse.grid, block.x=1000)
image(meuse.grid)
lines(as(tl, "SpatialLines"))
## all at once:
pix.lst <- tile(meuse.grid, block.x=1000)
\donttest{
  library(rgdal)
  ## raster files via rgdal:
  fn = system.file("pictures/SP27GTIF.TIF",
                   package = "rgdal")
  obj <- GDALinfo(fn)
  ras.lst <- getSpatialTiles(obj, block.x=1000)
  offset <- c(ras.lst$offset.y[1], ras.lst$offset.x[1])
  region.dim <- c(ras.lst$region.dim.y[1],
                  ras.lst$region.dim.x[1])
  ## read the first tile:
  SP27GTIF_T1 <- readGDAL(fn, offset=offset,
                          region.dim=region.dim)
  str(SP27GTIF_T1)
}
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
