% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMaxLength.R
\name{lakeMaxLength}
\alias{lakeMaxLength}
\title{Caluclate maximum lake length}
\usage{
lakeMaxLength(inLakeMorpho, pointDens, addLine = T)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{pointDens}{Number of points to place equidistant along shoreline. The 
maximum point to point distance that does not also intersect the 
shoreline is used.  To total of n*(n-1)/2 comparisons is possible, but
in practice is usually significant less.}

\item{addLine}{Boolean to determine if the selected max length line should be 
added to the inLakeMorpho object.  Defaults to True}
}
\value{
This returns a numeric value indicating the length of the longest 
        line possible in the lake. Units are the same as the input data.
}
\description{
Maximum lake length is defined as the longest open water distance of a lake.
This function determines the maximum lake length of lake by comparing the 
lenghts of a user defined number of lines.  The user specifies a number of 
points to distribute along the lake shoreline and the point to point line 
lengths are checked for multiple intersections (i.e. line not just open 
water),starting with the longest line first.  Function is currently very 
sensitive to \code{pointDens} and slows down considerably for larger values.
Small values of point dens are acceptable for lakes withtout complex 
shorelines.  Care needs to be taken in selecting an approriate 
\code{pointDens} and multiple values should be checked to ensure stability
in the estimates.
}
\examples{
data(lakes)
lakeMaxLength(inputLM,50)
}
\references{
Florida LAKEWATCH (2001). A Beginner's guide to water management
            - Lake Morphometry (2nd ed.). Gainesville: Florida LAKEWATCH, 
            Department of Fisheries and Aquatic Sciences.
            \href{http://edis.ifas.ufl.edu/pdffiles/FA/FA08100.pdf}{Link}
}
