% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbl.R
\name{gbl}
\alias{gbl}
\alias{gbl.cvchat}
\title{Gliding box lacunarity estimation using all estimators}
\usage{
gbl(xi, boxwidths, estimators = c("GBLg.mattfeldt", "GBLg.pickaint",
  "GBLg.pickaH", "GBLcc.mattfeldt", "GBLcc.pickaint", "GBLc", "GBLemp"),
  obswin = NULL, includenormed = FALSE,
  setcov_boundarythresh = 1e-06)

gbl.cvchat(boxwidths, estimators = c("GBLg.mattfeldt", "GBLg.pickaint",
  "GBLg.pickaH", "GBLcc.mattfeldt", "GBLcc.pickaint", "GBLc"),
  phat = NULL, cvchat = NULL, cpp1 = NULL)
}
\arguments{
\item{xi}{An observation of a RACS of interest as a full binary map (as an \code{im} object) or as the foreground set (as an \code{owin} object).
In the latter case the observation window, \code{obswin}, must be supplied.}

\item{boxwidths}{A list of box widths}

\item{estimators}{A list of estimator names - see details for possibilities. \code{estimators = "all"} will select all estimators.}

\item{obswin}{If \code{xi} is an \code{owin} object then \code{obswin} is an
\code{owin} object that specifies the observation window.}

\item{includenormed}{A logical value. If TRUE then GBL estimates normalised by the GBL values at zero will be included in a returned list of \code{fv} objects}

\item{setcov_boundarythresh}{To avoid instabilities caused by dividing by very small quantities, if the set covariance of the observation window
 is smaller than \code{setcov_boundarythresh}, then the covariance is given a value of NA. 
If NULL is supplied (default) then \code{setcov_boundarythresh} is set to 1E-6.}

\item{phat}{The fraction of foreground area in the observation window, which is the usual estimator of coverage probability given by \code{\link{coverageprob}}.}

\item{cvchat}{The plug-in moment covariance estimate (often from \code{\link{plugincvc}}).}

\item{cpp1}{Picka's estimate of coverage probability for subsets of the observation window. See \code{\link{cppicka}}.}
}
\value{
An \code{fv} object.
}
\description{
Estimates gliding box lacunarity (GBL) for square boxes using all estimators described in (Hingee et al., 2017).
It calls the functions \code{\link{gblc}}, \code{\link{gblg}}, \code{\link{gblcc}} and \code{\link{gblemp}}.
}
\details{
As empirical GBL is one of the GBL estimators available through this function, non-square boxes are not allowed.
To estimate GBL for non-square boxes use \code{gblcc} or \code{gblg} directly.

If \code{xi} is an \code{owin} object then \code{obswin} and \code{xi} are converted
 into an \code{im} object using \code{\link[spatstat]{as.im}}

The estimators available are
\itemize{
\item{\code{"GBLc"}} The unmodified (unbalanced) covariance estimator provided by \code{\link{gblc}}
\item{\code{"GBLemp"}} Empirical gliding box lacunarity (Allain and Cloitre, 1991). Calls \code{\link{gblemp}}
\item{\code{"GBLg.mattfeldt"}} See help for \code{\link{gblg}} and \code{\link{paircorr}}
\item{\code{"GBLg.pickaint"}} See help for \code{\link{gblg}} and \code{\link{paircorr}}
\item{\code{"GBLg.pickaH"}} See help for \code{\link{gblg}} and \code{\link{paircorr}}
\item{\code{"GBLcc.mattfeldt"}} See help for \code{\link{gblcc}}
\item{\code{"GBLcc.pickaint"}} See help for \code{\link{gblcc}}
\item{\code{"GBLcc.pickaH"}} See help for \code{\link{gblcc}}
}

The set covariance of the boxes is computed empirically using \pkg{spatstat}'s \code{\link[spatstat]{setcov}} function, which converts \eqn{B} into a binary pixel mask using \code{\link[spatstat]{as.mask}} defaults. Computation speed can be increased by setting a small default number of pixels, \code{npixel}, in \pkg{spatstat}'s global options (accessed through \code{\link[spatstat]{spatstat.options}}), however fewer pixels also decreases the accuracy of the GBL computation.
}
\section{Functions}{
\itemize{
\item \code{gbl}: computes GBL estimates from a binary map.

\item \code{gbl.cvchat}: computes covariance-based estimator of GBL from the plug-in moment estimate of covariance,
Picka's reduced window coverage probability estimates (see \code{\link{cppicka}}) and the usual coverage probability estimate, \code{phat}.
}}

\examples{
xi <- as.im(heather$coarse, value = TRUE,
            na.replace = FALSE)
boxwidths <- seq(1, 10, by = 0.5)

# reduce resolution in setcov() for faster (less accurate) computation 
oldopt <- spatstat.options()
spatstat.options("npixel" = 2^5)

gblests <- gbl(xi, boxwidths, estimators = "GBLg.pickaH")
spatstat.options(oldopt)
}
\references{
Allain, C. and Cloitre, M. (1991) Characterizing the lacunarity of random and deterministic fractal sets. \emph{Physical Review A}, 44, 3552-3558.

Hingee K, Baddeley A, Caccetta P, Nair G (2019). Computation of lacunarity from covariance of spatial binary maps. \emph{Journal of Agricultural, Biological and Environmental Statistics}, 24, 264-288. DOI: 10.1007/s13253-019-00351-9.
}
