% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepare_fit_dmax_mods}
\alias{prepare_fit_dmax_mods}
\title{Prepare modified Dmax fits}
\usage{
prepare_fit_dmax_mods(
  .data,
  fit = c("3rd degree polynomial", "Exponential"),
  intensity_to_start,
  sport = c("cycling", "running", "swimming")
)
}
\arguments{
\item{.data}{The data retrieved from \code{prepare_data()}.}

\item{fit}{The fit you would like to use for finding the lactate values associated to each one of the lactate thresholds.
Please, note that a few lactate thresholds have default methods for this and cannot be changed. See \code{Details}.}

\item{intensity_to_start}{A double indicating the intensity to start the fit.}

\item{sport}{The sport at which the incremental test was performed. One of \code{cycling}, \code{running}, or \code{swimming}.}
}
\value{
a \link[tibble:tibble-package]{tibble} with the following nested columns:
\item{data}{The raw data.}
\item{data_interpolated}{The interpolated data.}
\item{model}{The model chosen in the \code{fit} parameter.}
\item{data_augmented}{The augmented data retrieved from the model.}
\item{bsln}{A boolean indicating the \code{include_baseline} argument.}
}
\description{
This is a function for internal use only and it won't be exported.
}
\keyword{internal}
