% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_data_atts.R
\name{clean_data_atts}
\alias{clean_data_atts}
\title{"Clean" Data Frame Attributes}
\usage{
clean_data_atts(data)
}
\arguments{
\item{data}{a data.frame.}
}
\value{
A data.frame, with attributes re-arranged.
}
\description{
Drops name.lab and val.lab attributes associated with columns that are not
present in the data.frame (i.e., have been dropped) and re-arranges
data.frame attributes so that they appear in a clean, logical order.
}
\details{
labelr meta-data exist as data.frame attributes, added through interactive
use in a potentially haphazard order. This function, which is used inside
other labelr functions, drops labels for variables that are not (no longer)
present in the data.frame and re-arranges label and other data.frame
attributes to put them in a more, logical, user-readable order when accessed
via, e.g., \code{attributes()}.
}
\examples{
# make toy demographic (age, gender, raceth) data set
set.seed(555)
df <- make_demo_data(n = 1000)

# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Latino", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

# let's add variable VALUE labels for variable "gender"
df <- add_val1(
  data = df, gender, vals = c(0, 1, 2),
  labs = c("M", "F", "O"), max.unique.vals = 50
)

# let's add variable NAME labels
df <- add_name_labs(df, name.labs = c(
  "age" = "Age in years",
  "raceth" = "raceth category",
  "gender" = "gender assigned at birth"
))


# let's add a frame label
df <- add_frame_lab(df, frame.lab = "This is a fictional data set that includes
                    demographic variables. It is generated by
                    labelr::make_demo_data")

# show attributes
attributes(df)

# re-arrange and show attributes
df2 <- clean_data_atts(df)
attributes(df2)

# confirm that attributes from df are all present in df2
all(attributes(df) \%in\% attributes(df2)) # TRUE
}
