% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_m1_lab.R
\name{add_m1_lab}
\alias{add_m1_lab}
\alias{am1l}
\title{Apply One Label to Multiple Values}
\usage{
add_m1_lab(
  data,
  vars,
  vals,
  lab,
  partial = FALSE,
  not.vars = NULL,
  max.unique.vals = 10,
  init = FALSE
)

am1l(
  data,
  vars,
  vals,
  lab,
  partial = FALSE,
  not.vars = NULL,
  max.unique.vals = 10,
  init = FALSE
)
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{a character vector that corresponds to the name(s) of one or more
variables to which value labels will be added.}

\item{vals}{a vector of distinct values of the actual variable, each of which
is to be associated with the label supplied to the lab argument. Note: NA and
other "irregular" (e.g., NaN, Inf) values all are automatically assigned the
label "NA", and this cannot be overridden. Note that you do not need to
specify all unique vals of var, and you can supply value labels
incrementally, one (or a few, or all) unique vals of var at a time. However,
if you do this, do not re-use a value label or repeat a value-label
assignment you have already made: Once you've added the value label, it is
bound to those values until you drop the label (see \code{drop_val_labs}) or some
other action (intentional or otherwise) strips the value label attributes
from your data.frame (see, e.g. \code{strip_labs}).}

\item{lab}{a single distinct label that will be associated with all values
specified in your vals argument. Note: NA and other "irregular" (e.g.,
NaN, Inf) values are automatically assigned the label "NA" and may not be
assigned another label.}

\item{partial}{To apply the same value labeling scheme to many variables
at once, you can provide those variable names explicitly (e.g., vars =
c("x1","x2", "x3") or vars = paste0("x", 1:3), or you can provide a substring
only and set partial = TRUE (default is FALSE). For example, to apply the
same labeling scheme to vars "x1", "x2" ... sequentially through "x10",
you could use vars = c("x"), along with partial = TRUE. Be careful with
this, as it also will attempt to apply the scheme to "sex" or "tax.bracket",
etc.}

\item{not.vars}{use of the partial argument can result in situations where
you inadvertently attempt to value-label a variable. For example, if vars="x"
and partial=TRUE, then \code{add_m1_lab} will attempt to label not only "x1",
"x2","x3", and "x4", but also "sex", "tax.bracket.", and other "x"-containing
variable names. Use of not.vars allows you to indicate variables that match
your vars argument that you do not wish to attempt to value-label. Note that
not.vars gets priority: setting vars="x", partial=TRUE, and not.vars="x" is
tantamount to telling add_m1_lab() that you actually do not wish to label
any of the variables that you specified in vars, resulting in no variables
receiving value labels.}

\item{max.unique.vals}{\code{add_m1_lab}() will not assign value labels to non-
integer (i.e., decimal-having) numeric variables. The max.unique.vals
argument further constrains the variables that may receive value labels to
those whose total unique values do not exceed the integer value supplied to
this argument. Note that labelr sets a hard ceiling of 5000 on the total
number of unique value labels that any variable is permitted to have under
any circumstance, as labelr is primarily intended for interactive use with
moderately-sized (<=~1M-row) data.frames.}

\item{init}{assign placeholder labels for variables that lack decimals
and meet the max.unique.vals threshold.}
}
\value{
A data.frame, with new variable value labels added (call
\code{get_val_labs} to see them), other provisional/default labelr label
information added, and previous user-added labelr label information
preserved.
}
\description{
Apply a single variable value label to multiple values of a variable
("m1" is shorthand for "many values get one label").
}
\details{
Note: \code{am1l} is a compact alias for \code{add_m1_labs}: they do the same thing,
and the former is easier to type

add_m1_lab\verb{(and}add1m1\verb{) allows the user to assign the same value label to multiple distinct values of a variable ("m1" is short for "many-to-one"). This is in contrast to }add_val_labs\code{and}add_val1`, which require a strict
one-to-one mapping of distinct variable values and distinct value labels.

If partial = TRUE, \code{add_m1_lab} will apply the specified labeling scheme to
all variables that contain a key variable name substring of interest
(supplied to the vars argument), which may be one or more variables found in
the data.frame (see Example #2).
}
\examples{
df <- mtcars

df <- add_m1_lab(df,
  vars = "carb",
  vals = 1:3,
  lab = "<=3",
  max.unique.vals = 10
)

df <- add_m1_lab(df,
  vars = "carb",
  vals = c(4, 6, 8),
  lab = ">=4",
  max.unique.vals = 10
)

head(use_val_labs(df), 8) # they're there
}
