% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyApply}
\alias{keyApply}
\title{Apply variable key to data frame (generate recoded data frame)}
\usage{
keyApply(dframe, key, diagnostic = TRUE, safeNumericToInteger = TRUE,
  ignoreCase = TRUE, debug = FALSE)
}
\arguments{
\item{dframe}{An R data frame}

\item{key}{A variable key object, of class either "key" or "keylong"}

\item{diagnostic}{Default TRUE: Compare the old and new data
frames carefully with the keyDiagnostic function.}

\item{safeNumericToInteger}{Default TRUE: Should we treat values
which appear to be integers as integers? If a column is
numeric, it might be safe to treat it as an integer.  In many
csv data sets, the values coded c(1, 2, 3) are really
integers, not floats c(1.0, 2.0, 3.0). See \code{safeInteger}.}

\item{ignoreCase}{Default TRUE. If column name is capitalized
differently than name_old in the key, but the two are
otherwise identical, then the difference in capitalization
will be ignored.}

\item{debug}{Default FALSE. If TRUE, emit some warnings.}
}
\value{
A recoded version of dframe
}
\description{
This is the main objective of the variable key system.
}
\examples{
mydf.key.path <- system.file("extdata", "mydf.key.csv", package = "kutils")
mydf.key <-  keyImport(mydf.key.path)
mydf.path <- system.file("extdata", "mydf.csv", package = "kutils")

mydf <- read.csv(mydf.path, stringsAsFactors = FALSE)
mydf2 <- keyApply(mydf, mydf.key)

nls.keylong.path <- system.file("extdata", "natlongsurv.key_long.csv", package = "kutils")
nls.keylong <- keyImport(nls.keylong.path, long = TRUE)
data(natlongsurv)
nls.dat <- keyApply(natlongsurv, nls.keylong)

}

