% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkonfound_fig.R
\name{tkonfound_fig}
\alias{tkonfound_fig}
\title{Draw figures for change in effect size as a function of switching outcomes}
\usage{
tkonfound_fig(a, b, c, d, thr_p = 0.05, switch_trm = T)
}
\arguments{
\item{a}{cell is the number of cases in the control group showing unsuccessful results}

\item{b}{cell is the number of cases in the control group showing successful results}

\item{c}{cell is the number of cases in the treatment group showing unsuccessful results}

\item{d}{cell is the number of cases in the treatment group showing successful results}

\item{thr_p}{the p-value threshold used to evaluate statistical significance, with the default of 0.05}

\item{switch_trm}{whether switching the two cells in the treatment row or the two cells in the control row, with the default of the treatment row}
}
\value{
prints 2 figures for how number of hypothetical cases switched changes the effect size
}
\description{
This function returns two plots for change in effect size as a function of switching outcomes (RIS),
one for all possibilities, another zoomed in the area around the two thresholds
}
\examples{
# using tkonfound_fig for a study where 2 by 2 table is (35, 17, 17, 38)
tkonfound_fig(35, 17, 17, 38)
tkonfound_fig(35, 17, 17, 38, thr_p = 0.01)
tkonfound_fig(35, 17, 17, 38, thr_p = 0.01, switch_trm = FALSE)
}
