% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_split_by_doc_id.R
\docType{methods}
\name{split_by_doc_id}
\alias{split_by_doc_id}
\alias{split_by_doc_id,kRp.text-method}
\alias{split_by_doc_id,-methods}
\alias{split_by_doc_id,kRp.corpus-method}
\title{Turn a multi-document kRp.text object into a list of kRp.text objects}
\usage{
split_by_doc_id(obj, keepFeatures = TRUE)

\S4method{split_by_doc_id}{kRp.text}(obj, keepFeatures = TRUE)
}
\arguments{
\item{obj}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{keepFeatures}{Either logical, whether to keep all features or drop them,
      or a character vector
of names of features to keep if present.}
}
\value{
A named list of objects of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.
   Elements are named by their \code{doc_id}.
}
\description{
For some analysis steps it might be important to have individual tagged texts
instead of one large corpus object. This method produces just that.
}
\examples{
\dontrun{
myCorpusList <- split_by_doc_id(myCorpus)
}
}
