% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_nfi.R
\name{iv_nfi}
\alias{iv_nfi}
\title{Calculates the importance values for National Forest Inventory Data}
\usage{
iv_nfi(
  data,
  sp = "SP",
  frequency = TRUE,
  plotgrp = NULL,
  continuousplot = FALSE,
  clusterplot = FALSE,
  largetreearea = FALSE,
  stockedland = TRUE,
  talltree = TRUE
)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}} that contains 'plot' and 'tree' data frames.}

\item{sp}{:A character vector; the column name of species information (e.g., "SP" for species, "GENUS" for genus-level analysis).}

\item{frequency}{: A logical flag (default TRUE); if TRUE, includes frequency in importance value calculations.}

\item{plotgrp}{: A character vector; specifies variables from 'plot' table to use for grouping. Use \code{c()} to combine multiple variables.}

\item{continuousplot}{: A logical flag (default TRUE); if TRUE, includes only plots that have been continuously measured in all NFI cycles (5th, 6th, etc.). If FALSE, includes plots regardless of missing cycle measurements.}

\item{clusterplot}{: A logical flag (default FALSE); if TRUE, treats each cluster plot as a single unit. If FALSE, calculates for each subplot separately.}

\item{largetreearea}{: A logical flag (default FALSE); if TRUE, includes large tree survey plots in the analysis. If FALSE, only uses standard tree plots.}

\item{stockedland}{: A logical flag (default TRUE); if TRUE, includes only stocked land. If FALSE, includes all land types.}

\item{talltree}{: A logical flag (default TRUE); if TRUE, includes only tall trees. If FALSE, includes both trees and shrubs.}
}
\value{
A \code{data.frame} that includes importance value for tree species. Each row represents a combination of a tree species and groups specified by plotgrp and treegrp.
}
\description{
iv_nfi() function calculates the importance values of tree species based on frequency, density and coverage.
It can estimate the entire study area or specific groups within it using the \code{plotgrp} parameter.
It uses the \code{\link[BiodiversityR]{importancevalue}} function from the \pkg{BiodiversityR} package for core calculations.
Users have flexibility in specifying data inclusion criteria and analysis levels using parameters \code{frequency}, \code{clusterplot}, \code{largetreearea}, \code{stockedland}, and \code{talltree}.
These parameters determine whether to include frequency in importance calculations, to treat cluster plots as single plots, to include large tree survey plots, and to focus only on Stocked land and tall trees.
}
\details{
The importance value (ranging from 0 to 100) is calculated as the mean of:
\enumerate{
\item Relative frequency: (number of plots where a species is observed / total survey plots) * 100
\item Relative density: (total number of individuals of a species / sum of all species' densities) * 100
\item Relative coverage: (total basal area of a species / sum of all species' basal area) * 100
}
}
\note{
\itemize{
\item Consider calculating importance by genus rather than species due to potential incompleteness in species classification.
\item Since the frequencies of each species may be identical across the nation, it may be desirable to exclude frequency from the importance calculation.
}
}
\examples{

data("nfi_donghae")
# Calculate importance values without frequency
importance <- iv_nfi(nfi_donghae, sp = "SP", frequency = FALSE, continuousplot = TRUE)

# Calculate importance values using genus
genus_importance <- iv_nfi(nfi_donghae, sp = "GENUS", continuousplot = TRUE)

}
\references{
Curtis, J. T. & McIntosh, R. P. (1951). An upland forest continuum in the prairie-forest border region of Wisconsin. Ecology, 32(3), 476–496.
}
\seealso{
\code{\link[BiodiversityR]{importancevalue}} for calculating the importance values.
}
