% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepkmed.R
\name{stepkmed}
\alias{stepkmed}
\title{Step k-medoid algorithm from Yu et al.}
\usage{
stepkmed(distdata, ncluster, iterate = 10, alpha = 1)
}
\arguments{
\item{distdata}{A matrix of distance objects (n x n) or a diss class.}

\item{ncluster}{A number of cluster.}

\item{iterate}{A number of iteration for clustering algorithm.}

\item{alpha}{A numeric number to determine the range of initial medoids
selection.}
}
\value{
Function returns a partitioning clustering algorithm result consists of cluster
membership, cluster medoid, the minimum distance to the cluster medoid.
}
\description{
This function computes and returns the clustering result
computed by using a specified distance via Yu et al. algorithm.
}
\details{
This is a k-medoids algorithm that has been proposed by Yu et al. The algorihm
has been claimed to be a remedy of simple and fast k-medoid. The medoids updating in this algorihm is similar to
simple and fast k-medoid.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- stepkmed(mrwdist, ncluster = 3, iterate = 50, alpha = 1.5)
table(result$cluster, iris[,5])


}
\references{
Yu, D., Liu, G., Guo, M., Liu, X., 2018. An improved K-medoids algorithm based on step increasing and optimizing medoids.
Expert Systems with Applications 92, 464-473.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
