% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_effects_analysis.R
\name{simple_effects_analysis}
\alias{simple_effects_analysis}
\title{Simple Effects Analysis}
\usage{
simple_effects_analysis(
  data = NULL,
  dv_name = NULL,
  iv_1_name = NULL,
  iv_2_name = NULL,
  iv_1_levels = NULL,
  iv_2_levels = NULL,
  print_contrast_table = "weights_sums_and_products",
  output = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable (DV)}

\item{iv_1_name}{name of the first independent variable (IV1), whose
main effects will be examined in the first set of contrasts}

\item{iv_2_name}{name of the second independent variable (IV2), whose
simple effects at each level of IV1 will be examined in the second set
of contrasts}

\item{iv_1_levels}{ordered levels of IV1}

\item{iv_2_levels}{ordered levels of IV2}

\item{print_contrast_table}{If
\code{print_contrast_table = "weights_sums_and_products"}, contrasts'
weights, sums of the weights and products will be printed. If
\code{print_contrast_table = "weights_only"}, only the contrasts will
be printed.}

\item{output}{output can be one of the following: \code{"lm_object"},
\code{"table"}, \code{"weights_only"}, \code{"weights_sums_and_products"},
\code{"all"} By default, \code{output = NULL}, and there will be no
output from the function other than the tables of simple effects and
constrasts which will be printed on the console by default.}
}
\value{
By default, the function will print a table of contrasts and
a table of simple effects.
}
\description{
Conduct a simple effects analysis to probe a two-way interaction effect.
See Field et al. (2012, ISBN: 978-1-4462-0045-2).
}
\examples{
\donttest{
two_way_anova(
  data = mtcars, dv_name = "mpg", iv_1_name = "vs",
  iv_2_name = "am", iterations = 100, plot = TRUE)
simple_effects_analysis(
  data = mtcars, dv_name = "mpg", iv_1_name = "vs",
  iv_2_name = "am")
}
}
