% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_csv.R
\name{read_csv}
\alias{read_csv}
\title{Read a csv file}
\usage{
read_csv(name = NULL, head = FALSE, dirname = NULL, ...)
}
\arguments{
\item{name}{a character string of the csv file name without the
".csv" extension. For example, if the csv file to read is "myfile.csv",
enter \code{name = "myfile"}}

\item{head}{logical. if \code{head = TRUE}, prints the first five
rows of the data set.}

\item{dirname}{a character string of the directory containing
the csv file, e.g., \code{dirname = "c:/Users/Documents"}}

\item{...}{optional arguments for the \code{fread} function
from the data.table package. Any arguments for data.table's \code{fread}
function can be used, e.g., \code{fill = TRUE}, \code{nrows = 100}}
}
\value{
the output will be a data.table object, that is,
an output from the data.table function, \code{fread}
}
\description{
Read a csv file
}
\examples{
\dontrun{
mydata <- read_csv("myfile")
}
}
