% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_stat_test_homo_r.R
\name{q_stat_test_homo_r}
\alias{q_stat_test_homo_r}
\title{Q statistic for testing homogeneity of correlations}
\usage{
q_stat_test_homo_r(z = NULL, n = NULL)
}
\arguments{
\item{z}{a vector of z values}

\item{n}{a vector of sample sizes which will be used to calculate the
weights, which in turn will be used to calculate the weighted z.}
}
\value{
the output will be a weighted z value.
}
\description{
Calculate the Q statistic to test for homogeneity of correlation
coefficients.
See p. 235 of the book Hedges & Olkin (1985),
Statistical Methods for Meta-Analysis (ISBN: 0123363802).
}
\examples{
q_stat_test_homo_r(1:3, c(100, 200, 300))
q_stat_test_homo_r(z = c(1:3, NA), n = c(100, 200, 300, NA))
}
