% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_groups.R
\name{compare_groups}
\alias{compare_groups}
\title{Compare groups}
\usage{
compare_groups(data = NULL, iv_name = NULL, dv_name = NULL, sigfigs = 3)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable (grouping variable)}

\item{dv_name}{name of the dependent variable (measure variable
of interest)}

\item{sigfigs}{number of significant digits to round to}
}
\value{
the output will be a list of (1) ggplot object
(histogram by group) (2) a data.table with descriptive statistics by
group; and (3) a data.table with pairwise comparison results
}
\description{
Compares groups by (1) creating histogram by group; (2) summarizing
descriptive statistics by group; and (3) conducting pairwise
comparisons (t-tests and Mann-Whitney tests).
}
\examples{
compare_groups(data = iris, iv_name = "Species", dv_name = "Sepal.Length")
}
